///////////////////////////////////////////////////////////////////////////////////////
//
// MonoScan
//
// 27/04/07		Hounddog	Initial implementation
//

using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
using System.Text;
using System.Xml;

namespace MonoScan.MonoMotronic121
{
	public class DescriptionsForm : MonoScan.TextForm
	{
		private System.ComponentModel.IContainer components = null;

		public DescriptionsForm(Scanner scanner, XmlNode xmlNode)
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();
			
			this.scanner = scanner;
			this.xmlNode = xmlNode;
		}

		protected Scanner scanner;
		protected XmlNode xmlNode;

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			// 
			// textBox
			// 
			this.textBox.Name = "textBox";
			this.textBox.Size = new System.Drawing.Size(392, 133);
			// 
			// DescriptionsForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(392, 133);
			this.Location = new System.Drawing.Point(10, 10);
			this.Name = "DescriptionsForm";
			this.Text = "Descriptions";

		}
		#endregion

		public void Execute()
		{
			int statusMessageId = scanner.MainForm.PushStatusMessage("Reading descriptions");

			try
			{
				scanner.MainForm.Update();

				string[] descriptions;
				MonoComm.Status status = MonoComm.GetDescriptions(out descriptions);

				if (status != MonoComm.Status.Ok)
					throw new MonoComm.Exception(status);

				StringBuilder stringBuilder = new StringBuilder();

				for (int index = 0; index < descriptions.Length; ++ index)
				{
					XmlNode descriptionXmlNode = Configuration.FindXmlNode(xmlNode, "Description[@Code={0}]", index + 1);

					if (descriptionXmlNode != null)
					{
						string description = Configuration.GetXmlNodeAttribute(descriptionXmlNode, "Description");
						stringBuilder.AppendFormat("\r\n     {0} : {1}", description, descriptions[index]);
					}
					else
						stringBuilder.AppendFormat("\r\n     Description {0} : {1}", index, descriptions[index]);
				}

				textBox.Text = stringBuilder.ToString();
				textBox.SelectionLength = 0;
			}
			finally 
			{
				scanner.MainForm.PopStatusMessage(statusMessageId);
			}
		}
	}
}

